<?php 
    include 'db_connect.php'; 
    include 'header.php'; 
?>

<section class="page-hero" style="height: 40vh; background: linear-gradient(rgba(42, 10, 46, 0.185), rgba(42, 10, 46, 0.185)), url('images/judge-s-gavel-table-court-room-closeup-concept-justice-law-generative-ai.jpg') no-repeat center center/cover;">
    <div class="container">
        <h1>Special Determination</h1>
        <p>Decisions of the Supreme Court on the constitutionality of Bills.</p>
    </div>
</section>

<section class="content-section reveal" style="padding: 80px 8%; background-color: #fff;">
    
    <div style="display: flex; justify-content: space-between; align-items: flex-end; margin-bottom: 20px; flex-wrap: wrap; gap: 20px;">
        
        <div style="flex: 1; min-width: 200px;">
            <label style="display: block; margin-bottom: 8px; color: #555; font-size: 0.9rem;">Filter by Year:</label>
            <select class="form-control" style="width: 100%; max-width: 300px; padding: 10px; border: 1px solid #ddd; border-radius: 4px;">
                <option>All Years</option>
                <option>2025</option>
                <option>2024</option>
                <option>2023</option>
            </select>
        </div>

        <div style="flex: 1; min-width: 200px; text-align: right;">
            <label style="display: block; margin-bottom: 8px; color: #555; font-size: 0.9rem;">Filter records:</label>
            <input type="text" class="form-control" style="width: 100%; max-width: 300px; padding: 10px; border: 1px solid #ddd; border-radius: 4px; display: inline-block;">
        </div>
    </div>

    <div class="table-responsive" style="overflow-x: auto;">
        <table class="custom-table" style="width: 100%; border-collapse: collapse; background: white; box-shadow: 0 5px 15px rgba(0,0,0,0.05);">
            <thead>
                <tr style="background-color: #f8f9fa; border-bottom: 2px solid #eee;">
                    <th style="padding: 15px; text-align: left; color: #333; font-weight: 700; background:none;">Case Number <i class="fas fa-sort" style="color:#ccc; font-size:0.8rem; margin-left:5px;"></i></th>
                    <th style="padding: 15px; text-align: left; color: #333; font-weight: 700; width: 100px; background:none;">Year <i class="fas fa-sort" style="color:#ccc; font-size:0.8rem; margin-left:5px;"></i></th>
                    <th style="padding: 15px; text-align: left; color: #333; font-weight: 700; width: 35%; background:none;">Name of Parties <i class="fas fa-sort" style="color:#ccc; font-size:0.8rem; margin-left:5px;"></i></th>
                    <th style="padding: 15px; text-align: center; color: #333; font-weight: 700; width: 120px; background:none;">File <i class="fas fa-sort" style="color:#ccc; font-size:0.8rem; margin-left:5px;"></i></th>
                </tr>
            </thead>
            <tbody>
                <tr style="border-bottom: 1px solid #eee;">
                    <td style="padding: 15px; color: #555;">SC SD No. 01/2025, SC SD No. 02/2025, Local Authorities Elections (Special Provisions) Bill</td>
                    <td style="padding: 15px; color: #555;">2025</td>
                    <td style="padding: 15px; color: #555;">Petitioner vs Attorney General</td>
                    <td style="padding: 15px; text-align: center;">
                        <a href="#" class="btn-download" style="background-color: #001f3f; color: white; padding: 6px 15px; font-size: 0.75rem; text-decoration: none; border-radius: 3px; display:inline-block;">View File</a>
                    </td>
                </tr>
                <tr style="border-bottom: 1px solid #eee; background-color: #fcfcfc;">
                    <td style="padding: 15px; color: #555;">SC SD No. 54/2024, SC SD No. 55/2024</td>
                    <td style="padding: 15px; color: #555;">2024</td>
                    <td style="padding: 15px; color: #555;">-</td>
                    <td style="padding: 15px; text-align: center;">
                        <a href="#" class="btn-download" style="background-color: #001f3f; color: white; padding: 6px 15px; font-size: 0.75rem; text-decoration: none; border-radius: 3px; display:inline-block;">View File</a>
                    </td>
                </tr>
                <tr style="border-bottom: 1px solid #eee;">
                    <td style="padding: 15px; color: #555;">S.C.S.D. No. 56/2024, S.C.S.D. No. 57/2024, Sri Lanka Telecommunications (Amendment) Bill Determination</td>
                    <td style="padding: 15px; color: #555;">2024</td>
                    <td style="padding: 15px; color: #555;">-</td>
                    <td style="padding: 15px; text-align: center;">
                        <a href="#" class="btn-download" style="background-color: #001f3f; color: white; padding: 6px 15px; font-size: 0.75rem; text-decoration: none; border-radius: 3px; display:inline-block;">View File</a>
                    </td>
                </tr>
                <tr style="border-bottom: 1px solid #eee; background-color: #fcfcfc;">
                    <td style="padding: 15px; color: #555;">SC SD No. 13/2023</td>
                    <td style="padding: 15px; color: #555;">2023</td>
                    <td style="padding: 15px; color: #555;">-</td>
                    <td style="padding: 15px; text-align: center;">
                        <a href="#" class="btn-download" style="background-color: #001f3f; color: white; padding: 6px 15px; font-size: 0.75rem; text-decoration: none; border-radius: 3px; display:inline-block;">View File</a>
                    </td>
                </tr>
                <tr style="border-bottom: 1px solid #eee;">
                    <td style="padding: 15px; color: #555;">S.C.S.D. No. 22/2023, S.C.S.D. No. 23/2023... SC SD No. 35/2023</td>
                    <td style="padding: 15px; color: #555;">2023</td>
                    <td style="padding: 15px; color: #555;">-</td>
                    <td style="padding: 15px; text-align: center;">
                        <a href="#" class="btn-download" style="background-color: #001f3f; color: white; padding: 6px 15px; font-size: 0.75rem; text-decoration: none; border-radius: 3px; display:inline-block;">View File</a>
                    </td>
                </tr>
            </tbody>
        </table>
        
        <div style="margin-top: 20px; display: flex; justify-content: space-between; align-items: center; color: #666; font-size: 0.9rem;">
            <div>Showing 1 to 10 of 16 entries</div>
            <div>
                <button style="padding: 5px 10px; border: 1px solid #ddd; background: white; cursor: pointer; color: #555;">Previous</button>
                <button style="padding: 5px 12px; border: 1px solid #ddd; background: #eee; cursor: pointer; color: #333;">1</button>
                <button style="padding: 5px 12px; border: 1px solid #ddd; background: white; cursor: pointer; color: #333;">2</button>
                <button style="padding: 5px 10px; border: 1px solid #ddd; background: white; cursor: pointer; color: #555;">Next</button>
            </div>
        </div>
    </div>

</section>

<script>
    window.addEventListener('scroll', function() {
        var reveals = document.querySelectorAll('.reveal');
        for(var i = 0; i < reveals.length; i++){
            var windowheight = window.innerHeight;
            var revealtop = reveals[i].getBoundingClientRect().top;
            var revealpoint = 150;
            if(revealtop < windowheight - revealpoint){
                reveals[i].classList.add('active');
            }
        }
    });
</script>

<?php include 'footer.php'; ?>