<?php 
    include 'db_connect.php'; 
    include 'header.php'; 
?>

<section class="page-hero" style="height: 40vh; background: linear-gradient(rgba(42, 10, 46, 0.85), rgba(42, 10, 46, 0.7)), url('images/hero-bg.jpg') no-repeat center center/cover;">
    <div class="container">
        <h1>News & Notices</h1>
        <p style="text-transform: uppercase; font-size: 0.9rem; letter-spacing: 1px;">Home > Notices</p>
    </div>
</section>

<section class="content-section reveal" style="padding: 80px 8%; background-color: #fff;">
    
    <div style="display: flex; justify-content: space-between; align-items: flex-end; margin-bottom: 50px; flex-wrap: wrap; gap: 30px;">
        <div style="flex: 1; min-width: 300px;">
            <p style="color: var(--gold-accent); text-transform: uppercase; letter-spacing: 2px; font-size: 0.8rem; margin-bottom: 10px;">News & Events</p>
            <h2 style="font-size: 2.5rem; color: var(--primary-color); line-height: 1.2;">
                Keep in touch with our <span style="font-family: 'Playfair Display', serif; font-style: italic; color: var(--gold-accent);">news & announcements</span>
            </h2>
            <div style="width: 50px; height: 3px; background-color: var(--gold-accent); margin-top: 15px;"></div>
        </div>
        <div style="flex: 1; min-width: 300px; color: #666; font-size: 0.95rem; line-height: 1.6;">
            We provide timely updates on important news, press releases, and official announcements issued by the High Court of Sri Lanka, helping the public stay informed about judicial developments.
        </div>
    </div>

    <div class="news-grid" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px;">
        
        <div class="news-item-card">
            <div class="news-meta">
                <span><i class="far fa-calendar-alt"></i> Aug 06, 2025</span>
                <span><i class="far fa-user"></i> By Admin</span>
            </div>
            <h3 class="news-title">Speech made by His Lordship the Chief Justice at the ceremonial sitting</h3>
            <a href="#" class="btn-black">View more</a>
        </div>

        <div class="news-item-card">
            <div class="news-meta">
                <span><i class="far fa-calendar-alt"></i> Jul 29, 2025</span>
                <span><i class="far fa-user"></i> By Admin</span>
            </div>
            <h3 class="news-title">Admission and Enrolment of an Attorney-at-Law.</h3>
            <a href="#" class="btn-black">View more</a>
        </div>

        <div class="news-item-card">
            <div class="news-meta">
                <span><i class="far fa-calendar-alt"></i> Jul 29, 2025</span>
                <span><i class="far fa-user"></i> By Admin</span>
            </div>
            <h3 class="news-title">OATH CEREMONY – MAY 2025</h3>
            <a href="#" class="btn-black">View more</a>
        </div>

        <div class="news-item-card">
            <div class="news-meta">
                <span><i class="far fa-calendar-alt"></i> Jun 15, 2025</span>
                <span><i class="far fa-user"></i> By Registrar</span>
            </div>
            <h3 class="news-title">Notice regarding the transfer of cases to Court Room 403</h3>
            <a href="#" class="btn-black">View more</a>
        </div>

    </div>

    <div style="margin-top: 50px; text-align: center;">
        <a href="#" style="display: inline-block; padding: 10px 20px; background: var(--primary-color); color: white; text-decoration: none; border-radius: 4px;">Load More News</a>
    </div>

</section>

<script>
    window.addEventListener('scroll', function() {
        var reveals = document.querySelectorAll('.reveal');
        for(var i = 0; i < reveals.length; i++){
            var windowheight = window.innerHeight;
            var revealtop = reveals[i].getBoundingClientRect().top;
            var revealpoint = 150;
            if(revealtop < windowheight - revealpoint){
                reveals[i].classList.add('active');
            }
        }
    });
</script>

<?php include 'footer.php'; ?>