<?php 
    include 'db_connect.php'; 
    include 'header.php'; 
?>

<section class="page-hero" style="height: 40vh; background: linear-gradient(rgba(42, 10, 46, 0.185), rgba(42, 10, 46, 0.185)), url('images/judge-s-gavel-table-court-room-closeup-concept-justice-law-generative-ai.jpg') no-repeat center center/cover;">
    <div class="container">
        <h1>Live Case List</h1>
        <p>Real-time updates on ongoing proceedings in the High Court.</p>
    </div>
</section>

<section class="content-section reveal" style="padding: 80px 8%; background-color: #fff; min-height: 50vh; display: flex; align-items: center; justify-content: center;">
    
    <div class="clock-wrapper" style="text-align: center; padding: 50px 0;">
        
        <i class="far fa-clock clock-icon" style="font-size: 4rem; color: #ccc; margin-bottom: 20px; display: inline-block;"></i>
        
        <div style="margin-bottom: 30px;">
            <div id="live-time" style="font-size: 5rem; font-weight: 700; color: var(--primary-color); font-family: 'Roboto', sans-serif; line-height: 1;">
                00:00:00
            </div>
            <div id="live-date" style="font-size: 1.2rem; color: var(--gold-accent); text-transform: uppercase; letter-spacing: 2px; margin-top: 10px;">
                Loading Date...
            </div>
        </div>
        
        <h2 style="color:#555; margin-bottom:10px; font-size: 1.8rem;">Proceedings have not started yet.</h2>
        <p style="color:#666; font-size: 1.1rem;">Please check back later for live updates from the courtrooms.</p>
        
        <div style="margin-top: 30px;">
            <a href="index.php" class="btn-gold" style="display: inline-block; padding: 10px 25px; text-decoration: none; border-radius: 4px;">Return Home</a>
        </div>
    </div>

</section>

<script>
    function updateClock() {
        const now = new Date();
        
        // 1. Format Time (HH:MM:SS AM/PM)
        let hours = now.getHours();
        const minutes = String(now.getMinutes()).padStart(2, '0');
        const seconds = String(now.getSeconds()).padStart(2, '0');
        const ampm = hours >= 12 ? 'PM' : 'AM';
        
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        
        const timeString = `${hours}:${minutes}:${seconds} ${ampm}`;
        
        // 2. Format Date (Day, Month Date, Year)
        const options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
        const dateString = now.toLocaleDateString('en-US', options);

        // 3. Update HTML
        document.getElementById('live-time').textContent = timeString;
        document.getElementById('live-date').textContent = dateString;
    }

    // Run immediately, then every second
    updateClock();
    setInterval(updateClock, 1000);

    // Scroll Animation (Keep existing)
    window.addEventListener('scroll', function() {
        var reveals = document.querySelectorAll('.reveal');
        for(var i = 0; i < reveals.length; i++){
            var windowheight = window.innerHeight;
            var revealtop = reveals[i].getBoundingClientRect().top;
            var revealpoint = 150;
            if(revealtop < windowheight - revealpoint){
                reveals[i].classList.add('active');
            }
        }
    });
</script>

<?php include 'footer.php'; ?>