<?php 
    include 'db_connect.php'; 
    include 'header.php'; 
?>

<section class="page-hero" style="height: 40vh; background: linear-gradient(rgba(42, 10, 46, 0.185), rgba(42, 10, 46, 0.185)), url('images/judge-s-gavel-table-court-room-closeup-concept-justice-law-generative-ai.jpg') no-repeat center center/cover;">
    <div class="container">
        <h1>Judgments</h1>
        <p>Access the full archive of judgments and legal determinations.</p>
    </div>
</section>

<section class="content-section reveal" style="padding: 80px 8%; background-color: #fff;">
    
    <div class="filter-container" style="background: #f4f4f4; padding: 20px; border-radius: 8px; margin-bottom: 30px; display: flex; gap: 20px; align-items: end; flex-wrap: wrap;">
        <div class="form-group" style="display: flex; flex-direction: column;">
            <label style="font-size: 0.9rem; margin-bottom: 5px; color: #555; font-weight: 600;">Case Type:</label>
            <select class="form-control" style="padding: 10px 15px; border: 1px solid #ccc; border-radius: 4px; min-width: 180px;">
                <option>All</option>
                <option>SC APPEAL</option>
                <option>HC CROSS</option>
                <option>WRIT</option>
            </select>
        </div>
        <div class="form-group" style="display: flex; flex-direction: column;">
            <label style="font-size: 0.9rem; margin-bottom: 5px; color: #555; font-weight: 600;">Year:</label>
            <select class="form-control" style="padding: 10px 15px; border: 1px solid #ccc; border-radius: 4px; min-width: 150px;">
                <option>All</option>
                <option>2025</option>
                <option>2024</option>
                <option>2023</option>
            </select>
        </div>
        <div class="form-group" style="display: flex; flex-direction: column;">
            <label style="font-size: 0.9rem; margin-bottom: 5px; color: #555; font-weight: 600;">Month:</label>
            <select class="form-control" style="padding: 10px 15px; border: 1px solid #ccc; border-radius: 4px; min-width: 150px;">
                <option>All</option>
                <option>August</option>
                <option>July</option>
                <option>June</option>
            </select>
        </div>
        <button class="btn-gold" style="border:none; cursor:pointer; height: 40px;">Filter</button>
    </div>

    <div style="display: flex; justify-content: space-between; margin-bottom: 15px; flex-wrap: wrap; gap: 10px;">
        <div>
            Show 
            <select style="padding: 5px;">
                <option>10</option>
                <option>25</option>
                <option>50</option>
            </select> 
            entries
        </div>
        <div>
            Search: <input type="text" style="padding: 5px; border: 1px solid #ccc;">
        </div>
    </div>

    <div class="table-responsive" style="overflow-x: auto;">
        <table class="custom-table" style="width: 100%; border-collapse: collapse; background: white; box-shadow: 0 5px 15px rgba(0,0,0,0.05);">
            <thead>
                <tr style="background-color: var(--primary-color); color: white;">
                    <th style="padding: 15px; text-align: left;">Created Date</th>
                    <th style="padding: 15px; text-align: left;">Case No</th>
                    <th style="padding: 15px; text-align: left; width: 40%;">Parties</th>
                    <th style="padding: 15px; text-align: left;">Judgment By</th>
                    <th style="padding: 15px; text-align: center;">Document</th>
                </tr>
            </thead>
            <tbody>
                <tr style="border-bottom: 1px solid #eee;">
                    <td style="padding: 15px; color: #444; vertical-align: top;">2025-08-08</td>
                    <td style="padding: 15px; color: #444; font-weight: bold; vertical-align: top;">SC/APPEAL/106/2021</td>
                    <td style="padding: 15px; color: #555; font-size: 0.9rem; vertical-align: top;">
                        1. Anil Prasanna De Silva, Attorney-at-Law, No. 310/2, Negombo Road, Kurunegala.<br>
                        2. L.H. Kithsiri Jayawardena, Attorney-at-Law, No. 310/2...
                        <a href="#" style="color: var(--primary-color); font-size: 0.8rem;">View More</a>
                    </td>
                    <td style="padding: 15px; color: #444; vertical-align: top;">Hon. S. Thurairaja, PC, J</td>
                    <td style="padding: 15px; text-align: center; vertical-align: top;">
                        <a href="#" class="btn-download" style="background-color: #000; color: white; padding: 6px 12px; font-size: 0.75rem; text-decoration: none; border-radius: 3px;">Download</a>
                    </td>
                </tr>
                <tr style="border-bottom: 1px solid #eee; background-color: #fcfcfc;">
                    <td style="padding: 15px; color: #444; vertical-align: top;">2025-08-07</td>
                    <td style="padding: 15px; color: #444; font-weight: bold; vertical-align: top;">SC/APPEAL/59/2021</td>
                    <td style="padding: 15px; color: #555; font-size: 0.9rem; vertical-align: top;">
                        S.T. Jayasundara, No. 129, Station Road, Udahamulla, Nugegoda.<br>
                        Vs.<br>
                        The Attorney General, Attorney General's Department...
                        <a href="#" style="color: var(--primary-color); font-size: 0.8rem;">View More</a>
                    </td>
                    <td style="padding: 15px; color: #444; vertical-align: top;">Hon. Arjuna Obeyesekere, J</td>
                    <td style="padding: 15px; text-align: center; vertical-align: top;">
                        <a href="#" class="btn-download" style="background-color: #000; color: white; padding: 6px 12px; font-size: 0.75rem; text-decoration: none; border-radius: 3px;">Download</a>
                    </td>
                </tr>
                <tr style="border-bottom: 1px solid #eee;">
                    <td style="padding: 15px; color: #444; vertical-align: top;">2025-08-06</td>
                    <td style="padding: 15px; color: #444; font-weight: bold; vertical-align: top;">SC/HCCA/LA/66/2023</td>
                    <td style="padding: 15px; color: #555; font-size: 0.9rem; vertical-align: top;">
                        Percival Palamakumbura (Deceased), No. 18, De Alwis Avenue, Kalutara.<br>
                        Substituted 1A: M. Palamakumbura...
                        <a href="#" style="color: var(--primary-color); font-size: 0.8rem;">View More</a>
                    </td>
                    <td style="padding: 15px; color: #444; vertical-align: top;">Hon. A.L. Shiran Gooneratne, J</td>
                    <td style="padding: 15px; text-align: center; vertical-align: top;">
                        <a href="#" class="btn-download" style="background-color: #000; color: white; padding: 6px 12px; font-size: 0.75rem; text-decoration: none; border-radius: 3px;">Download</a>
                    </td>
                </tr>
                 <tr style="border-bottom: 1px solid #eee; background-color: #fcfcfc;">
                    <td style="padding: 15px; color: #444; vertical-align: top;">2025-08-01</td>
                    <td style="padding: 15px; color: #444; font-weight: bold; vertical-align: top;">SC/FR/155/2019</td>
                    <td style="padding: 15px; color: #555; font-size: 0.9rem; vertical-align: top;">
                        1. W. Sunil Alwis, No. 24, Templers Road, Mount Lavinia.<br>
                        Vs.<br>
                        1. O.I.C. Police Station, Mount Lavinia...
                        <a href="#" style="color: var(--primary-color); font-size: 0.8rem;">View More</a>
                    </td>
                    <td style="padding: 15px; color: #444; vertical-align: top;">Hon. E. A. G. R. Amarasekara, J</td>
                    <td style="padding: 15px; text-align: center; vertical-align: top;">
                        <a href="#" class="btn-download" style="background-color: #000; color: white; padding: 6px 12px; font-size: 0.75rem; text-decoration: none; border-radius: 3px;">Download</a>
                    </td>
                </tr>
            </tbody>
        </table>
        
        <div style="margin-top: 20px; text-align: right; font-size: 0.9rem; color: #666;">
            Showing 1 to 4 of 122 entries 
            <span style="margin-left: 10px;">
                <button style="padding: 5px 10px; border: 1px solid #ddd; background: white; cursor: pointer;">Previous</button>
                <button style="padding: 5px 10px; border: 1px solid var(--gold-accent); background: var(--gold-accent); color: white; cursor: pointer;">1</button>
                <button style="padding: 5px 10px; border: 1px solid #ddd; background: white; cursor: pointer;">2</button>
                <button style="padding: 5px 10px; border: 1px solid #ddd; background: white; cursor: pointer;">3</button>
                <button style="padding: 5px 10px; border: 1px solid #ddd; background: white; cursor: pointer;">4</button>
                <button style="padding: 5px 10px; border: 1px solid #ddd; background: white; cursor: pointer;">5</button>
                <button style="padding: 5px 10px; border: 1px solid #ddd; background: white; cursor: pointer;">Next</button>
            </span>
        </div>
    </div>

</section>

<script>
    window.addEventListener('scroll', function() {
        var reveals = document.querySelectorAll('.reveal');
        for(var i = 0; i < reveals.length; i++){
            var windowheight = window.innerHeight;
            var revealtop = reveals[i].getBoundingClientRect().top;
            var revealpoint = 150;
            if(revealtop < windowheight - revealpoint){
                reveals[i].classList.add('active');
            }
        }
    });
</script>

<?php include 'footer.php'; ?>