<?php 
    include 'db_connect.php'; 
    include 'header.php'; 
?>

<section class="page-hero" style="height: 40vh; background: linear-gradient(rgba(42, 10, 46, 0.85), rgba(42, 10, 46, 0.7)), url('images/hero-bg.jpg') no-repeat center center/cover;">
    <div class="container">
        <h1>Information tO Citizens</h1>
        <p style="text-transform: uppercase; font-size: 0.9rem; letter-spacing: 1px;">Home > Information to Citizens</p>
    </div>
</section>

<section class="content-section reveal" style="padding: 80px 8%; background-color: #fff; min-height: 60vh;">
    
    <div style="max-width: 900px; margin: 0 auto;">
        
        <div style="background-color: #f9f9f9; padding: 40px; border-radius: 5px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); margin-bottom: 40px;">
            
            <div style="margin-bottom: 20px;">
                <label style="display: block; color: #555; margin-bottom: 8px; font-weight: 500;">Case Type</label>
                <select class="form-control" style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; background: white; color: #777;">
                    <option>Select Case Type</option>
                    <option>Writ Application</option>
                    <option>Appeal</option>
                    <option>Revision</option>
                </select>
            </div>

            <div style="margin-bottom: 20px;">
                <label style="display: block; color: #555; margin-bottom: 8px; font-weight: 500;">Serial Number</label>
                <input type="text" class="form-control" style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px;">
            </div>

            <div style="margin-bottom: 30px;">
                <label style="display: block; color: #555; margin-bottom: 8px; font-weight: 500;">Year</label>
                <select class="form-control" style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; background: white; color: #777;">
                    <option>Select Year</option>
                    <option>2025</option>
                    <option>2024</option>
                    <option>2023</option>
                </select>
            </div>

            <button style="width: 100%; background-color: #0077b6; color: white; border: none; padding: 15px; font-size: 1rem; font-weight: bold; border-radius: 4px; cursor: pointer; text-transform: uppercase; transition: 0.3s;">
                Search
            </button>
        </div>

        <div style="display: flex; gap: 30px; flex-wrap: wrap;">
            
            <div style="flex: 1; min-width: 300px; background-color: #f9f9f9; padding: 30px; border-radius: 5px; box-shadow: 0 5px 15px rgba(0,0,0,0.05);">
                <label style="display: block; color: #555; margin-bottom: 8px; font-weight: 500;">Search by Supreme Court Case No</label>
                <input type="text" class="form-control" style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; margin-bottom: 20px;">
                <button style="width: 100%; background-color: #0077b6; color: white; border: none; padding: 12px; font-size: 0.9rem; font-weight: bold; border-radius: 4px; cursor: pointer; text-transform: uppercase;">
                    Search
                </button>
            </div>

            <div style="flex: 1; min-width: 300px; background-color: #f9f9f9; padding: 30px; border-radius: 5px; box-shadow: 0 5px 15px rgba(0,0,0,0.05);">
                <label style="display: block; color: #555; margin-bottom: 8px; font-weight: 500;">Search by Lower Court Case No</label>
                <input type="text" class="form-control" style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; margin-bottom: 20px;">
                <button style="width: 100%; background-color: #0077b6; color: white; border: none; padding: 12px; font-size: 0.9rem; font-weight: bold; border-radius: 4px; cursor: pointer; text-transform: uppercase;">
                    Search
                </button>
            </div>

        </div>

    </div>
</section>

<script>
    window.addEventListener('scroll', function() {
        var reveals = document.querySelectorAll('.reveal');
        for(var i = 0; i < reveals.length; i++){
            var windowheight = window.innerHeight;
            var revealtop = reveals[i].getBoundingClientRect().top;
            var revealpoint = 150;
            if(revealtop < windowheight - revealpoint){
                reveals[i].classList.add('active');
            }
        }
    });
</script>

<?php include 'footer.php'; ?>