<?php 
    include 'db_connect.php'; 
    include 'header.php'; 
?>

<section class="hero">
    
    <div class="hero-slideshow">
        <div class="slide active" style="background-image: url('images/front-view-blurry-lawyer-working.jpg');"></div>
        <div class="slide" style="background-image: url('images/law-justice-gavel-statue-books.jpg');"></div>
        <div class="slide" style="background-image: url('images/judge-holding-gavel-courtroom.jpg');"></div>
    </div>

    <div class="hero-overlay"></div>

    <div class="hero-content">
        <h2>Safeguarding Justice & Upholding the Rule of Law</h2>
<p>Delivering fair, timely, and impartial justice to every citizen across Sri Lanka.</p>

        <a href="#" class="btn-gold">View Daily Court List</a>
    </div>

</section>

<script>
    let currentSlide = 0;
    const slides = document.querySelectorAll('.slide');
    const totalSlides = slides.length;

    function nextSlide() {
        // Remove 'active' class from current slide
        slides[currentSlide].classList.remove('active');
        
        // Calculate next slide index
        currentSlide = (currentSlide + 1) % totalSlides;
        
        // Add 'active' class to new slide
        slides[currentSlide].classList.add('active');
    }

    // Change slide every 5 seconds (5000ms)
    setInterval(nextSlide, 5000);
</script><br><br>

<section class="services-grid reveal">
    <div class="card">
        <i class="fas fa-gavel fa-3x" style="color:var(--primary-color)"></i>
        <h3>Case Status</h3>
        <p>Check the current status of ongoing cases in the High Court provinces.</p>
    </div>
    
    <div class="card">
        <i class="fas fa-calendar-alt fa-3x" style="color:var(--primary-color)"></i>
        <h3>Court Calendar</h3>
        <p>View the daily trial rolls and scheduled hearings for all divisions.</p>
    </div>

    <div class="card">
        <i class="fas fa-file-contract fa-3x" style="color:var(--primary-color)"></i>
        <h3>Bail Applications</h3>
        <p>Procedures and forms required for submitting bail applications.</p>
    </div>

    <div class="card">
        <i class="fas fa-balance-scale fa-3x" style="color:var(--primary-color)"></i>
        <h3>Judgments</h3>
        <p>Access the archive of recent judgments and legal precedents.</p>
    </div>
</section>

<div class="reveal" style="padding: 60px 8%; display:flex; gap:40px; flex-wrap:wrap;">
    <div style="flex: 1; min-width: 300px;">
        <h4 style="color:var(--gold-accent); text-transform:uppercase;">Welcome to</h4>
        <h2 style="color:var(--primary-color); font-size:2.5rem; margin-bottom:20px;">The High Court of Sri Lanka</h2>
        <p style="margin-bottom:20px;">
            The High Court is the only court in Sri Lanka that exercises original criminal jurisdiction over serious offenses. It also functions as an appellate court for appeals from the Magistrates' Courts and Primary Courts.
        </p>
        <p>
            Established under the Constitution, we are committed to delivering justice with integrity, impartiality, and efficiency.
        </p>
        <br>
        <a href="#" class="btn-gold" style="background:var(--primary-color); color:white; transition: 0.3s; display:inline-block;">Read More</a>
    </div>

    <div style="flex: 1; min-width: 300px;">
        <img class="hover-scale" src="https://courtofappeal.lk/wp-content/uploads/2021/12/grey-marble-column-details-building-scaled.jpg" alt="Court Complex" style="width:100%; border-radius:10px; box-shadow:0 10px 30px rgba(0,0,0,0.2);">
    </div>
</div>

<section class="news-section reveal" style="padding: 80px 8%; background-color: var(--bg-light);">
    <div style="text-align: center; margin-bottom: 50px;">
        <p style="font-family: 'Playfair Display', serif; font-style: italic; color: var(--gold-accent); font-size: 1.2rem;">Latest Updates</p>
        <h2 style="color: var(--primary-color); font-size: 2.2rem;">News & Judicial Announcements</h2>
        <div style="width: 50px; height: 3px; background-color: var(--gold-accent); margin: 15px auto;"></div>
    </div>

    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 25px;">
        
        <div class="news-card" style="background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 5px 15px rgba(0,0,0,0.05);">
            <img src="images/news/1.jpg" alt="Ceremonial Sitting" style="width: 100%; height: 200px; object-fit: cover;">
            <div style="padding: 20px;">
                <span style="font-size: 0.75rem; color: var(--gold-accent); font-weight: bold;">NEWS</span>
                <h4 style="margin: 10px 0; color: var(--primary-color);">Ceremonial Sitting for New High Court Judges</h4>
                <p style="font-size: 0.9rem; color: #666;">The ceremonial welcome for the newly appointed High Court Judges was held at the Superior Courts Complex.</p>
            </div>
        </div>

        <div class="news-card" style="background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 5px 15px rgba(0,0,0,0.05);">
            <img src="images/news/2.jpg" alt="Digital System" style="width: 100%; height: 200px; object-fit: cover;">
            <div style="padding: 20px;">
                <span style="font-size: 0.75rem; color: var(--gold-accent); font-weight: bold;">TECHNOLOGY</span>
                <h4 style="margin: 10px 0; color: var(--primary-color);">Expansion of E-Filing to Provincial High Courts</h4>
                <p style="font-size: 0.9rem; color: #666;">The Ministry of Justice announces the rollout of the digital case management system to Gampaha and Kandy High Courts.</p>
            </div>
        </div>

        <div class="news-card" style="background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 5px 15px rgba(0,0,0,0.05);">
            <img src="images/news/3.jpg" alt="Commercial Court" style="width: 100%; height: 200px; object-fit: cover;">
            <div style="padding: 20px;">
                <span style="font-size: 0.75rem; color: var(--gold-accent); font-weight: bold;">COMMERCIAL</span>
                <h4 style="margin: 10px 0; color: var(--primary-color);">New Guidelines for Commercial High Court Cases</h4>
                <p style="font-size: 0.9rem; color: #666;">Updated practice directions aimed at expediting intellectual property and financial disputes.</p>
            </div>
        </div>

        <div class="news-card" style="background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 5px 15px rgba(0,0,0,0.05);">
            <img src="images/news/4.jpg" alt="Judgment" style="width: 100%; height: 200px; object-fit: cover;">
            <div style="padding: 20px;">
                <span style="font-size: 0.75rem; color: var(--gold-accent); font-weight: bold;">JUDGMENTS</span>
                <h4 style="margin: 10px 0; color: var(--primary-color);">Key Landmark Ruling on Civil Jurisdiction</h4>
                <p style="font-size: 0.9rem; color: #666;">A recent judgment clarifying the scope of High Court jurisdiction in land matters involving state grants.</p>
            </div>
        </div>

    </div>
</section>

<section class="reveal" style="padding: 60px 8%; background-color: #fff; border-top: 1px solid #eee;">
    <div style="display: flex; gap: 40px; align-items: flex-start; flex-wrap: wrap;">
        <div style="flex: 2;">
            <h3 style="color: var(--primary-color); font-size: 1.8rem; margin-bottom: 10px;">Citizen's <span style="color: var(--gold-accent); font-family: 'Playfair Display', serif; font-style: italic;">Charter</span></h3>
            <p style="color: #666; font-size: 0.9rem; margin-bottom: 20px;">
                Department — High Courts of Sri Lanka<br>
                Basis of Charter — Implemented per Public Administration Circulars.
            </p>
            
            <h4 style="color: var(--primary-color); font-size: 1.1rem; margin-bottom: 15px;">Key Commitments:</h4>
            <ul class="charter-list" style="list-style: none; padding: 0;">
                <li style="margin-bottom: 10px; color: #555;"><i class="fas fa-check-circle" style="color: var(--gold-accent); margin-right: 10px;"></i> <strong>Fair Trial:</strong> Ensuring every accused person is afforded a fair and public hearing.</li>
                <li style="margin-bottom: 10px; color: #555;"><i class="fas fa-check-circle" style="color: var(--gold-accent); margin-right: 10px;"></i> <strong>Expediency:</strong> Minimizing delays in the judicial process for commercial and criminal matters.</li>
                <li style="margin-bottom: 10px; color: #555;"><i class="fas fa-check-circle" style="color: var(--gold-accent); margin-right: 10px;"></i> <strong>Accessibility:</strong> Providing clear guidance on bail applications and case tracking.</li>
            </ul>
        </div>
        
        <div style="flex: 1; min-width: 250px;">
            <img class="hover-scale" src="images/law-legal-system-justice-crime-concept-mallet-gavel-hammer-scales-table-d-render-illustration.jpg" alt="Court Pillars" style="width: 100%; height: 200px; object-fit: cover; border-radius: 5px;">
            <a href="#" class="btn-gold" style="display: block; text-align: center; margin-top: 15px; background: var(--primary-color); color: white; padding: 10px; text-decoration: none; border-radius: 4px; transition:0.3s;">Frequently Asked Questions (FAQ)</a>
        </div>
    </div>
</section>

<script>
    window.addEventListener('scroll', reveal);

    function reveal(){
        var reveals = document.querySelectorAll('.reveal');

        for(var i = 0; i < reveals.length; i++){
            var windowheight = window.innerHeight;
            var revealtop = reveals[i].getBoundingClientRect().top;
            var revealpoint = 150; // Trigger point

            if(revealtop < windowheight - revealpoint){
                reveals[i].classList.add('active');
            }
        }
    }
    
    // Trigger on load
    reveal();
</script>

<?php include 'footer.php'; ?>