<?php 
    include 'db_connect.php'; 
    include 'header.php'; 
?>

<section class="page-hero">
    <div class="overlay"></div>
    <div class="container">
        <h1>History of the High Court</h1>
        <p>Tracing the legacy of justice and the evolution of the judicial system in Sri Lanka.</p>
    </div>
</section>

<section class="history-section reveal">
    <div class="history-container">
        
        <div class="history-text">
            <h4 class="sub-title">The Foundation</h4>
            <h2>Origins of the Judicial System</h2>
            <div class="gold-divider"></div>
            
            <p>The judicial history of Sri Lanka is a rich tapestry woven through centuries of legal evolution, influenced by Roman-Dutch law, English Common Law, and indigenous legal traditions. The modern High Court of Sri Lanka, as it stands today, traces its definitive roots to the <strong>Constitution of the Democratic Socialist Republic of Sri Lanka (1978)</strong>.</p>
            
            <p>Prior to this, the administration of justice was handled through a complex hierarchy of courts established under the Administration of Justice Law of 1973 and earlier British colonial charters. The 1978 Constitution streamlined this system, explicitly establishing the High Court as the highest court of first instance for criminal jurisdiction.</p>

            <h3>The Provincial High Courts</h3>
            <p>A significant milestone in the history of the High Court was the <strong>13th Amendment to the Constitution</strong>, which paved the way for the establishment of Provincial High Courts. This decentralization ensured that justice was more accessible to citizens across the island, allowing commercial and civil appeals to be heard closer to their point of origin.</p>

            <blockquote>
                "Justice must not only be done, but must also be seen to be done." 
                <span>— Historic Legal Maxim</span>
            </blockquote>

            <h3>Modern Era & Digitalization</h3>
            <p>In recent decades, the High Court has undergone significant modernization. From the introduction of specialized High Courts for commercial and financial crimes to the recent implementation of the <strong>Electronic Filing System (E-Filing)</strong>, the court continues to evolve to meet the demands of the 21st century while upholding its sacred duty to the rule of law.</p>
        </div>

        <div class="history-sidebar">
            <div class="image-box">
                <img src="images/lady-justice-law-library-concept.jpg" alt="Old Court Building">
            </div>

            <div class="timeline-box">
                <h3>Key Milestones</h3>
                <ul>
                    <li>
                        <span class="year">1801</span>
                        <span class="event">Establishment of the Supreme Court of Judicature under the Charter of Justice.</span>
                    </li>
                    <li>
                        <span class="year">1978</span>
                        <span class="event">The 1978 Constitution formally establishes the High Court of Sri Lanka.</span>
                    </li>
                    <li>
                        <span class="year">1987</span>
                        <span class="event">13th Amendment introduces Provincial High Courts.</span>
                    </li>
                    <li>
                        <span class="year">1996</span>
                        <span class="event">Establishment of the Commercial High Court of Colombo.</span>
                    </li>
                </ul>
            </div>
        </div>

    </div>
</section>

<script>
    window.addEventListener('scroll', function() {
        var reveals = document.querySelectorAll('.reveal');
        for(var i = 0; i < reveals.length; i++){
            var windowheight = window.innerHeight;
            var revealtop = reveals[i].getBoundingClientRect().top;
            var revealpoint = 150;
            if(revealtop < windowheight - revealpoint){
                reveals[i].classList.add('active');
            }
        }
    });
</script>

<?php include 'footer.php'; ?>