<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>High Court of Sri Lanka</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>

<header id="main-header">
    
    <div class="logo-container">
        <img src="https://upload.wikimedia.org/wikipedia/commons/5/5f/Emblem_of_Sri_Lanka.svg" alt="Emblem of Sri Lanka">
        <div class="logo-text">
            <h1 class="court-name">High Court</h1>
            <p class="court-sub">of the Democratic Socialist Republic of Sri Lanka</p>
            <p class="court-loc">Superior Courts Complex - Colombo 12</p>
            <div class="logo-divider"></div>
        </div>
    </div>

    <nav id="navbar">
        <ul>
            <li><a href="index.php" class="active">Home</a></li>
            
            <li class="dropdown">
                <a href="#">About Us <i class="fas fa-chevron-down"></i></a>
                <ul class="dropdown-content">
                    <li><a href="history.php">History</a></li>
                    <li><a href="judges.php">Judges of the High Court</a></li>
                    <li><a href="past_judges.php">Past Judges</a></li>
                    <li><a href="speeches.php">Ceremonial Speeches</a></li>
                    <li><a href="#">Divisions of the Court</a></li>
                    <li><a href="#">Supreme Court Rules</a></li>
                </ul>
            </li>

            <li class="dropdown">
                <a href="#">Court Diary <i class="fas fa-chevron-down"></i></a>
                <ul class="dropdown-content">
                    <li><a href="live_cases.php">Live Case List</a></li>
                    <li><a href="daily_list.php">Daily Case List</a></li>
                    <li><a href="bench_list.php">Bench List</a></li>
                    <li><a href="full_diary.php">Full Court Diary</a></li>
                </ul>
            </li>

            <li class="dropdown">
            <a href="#">Judgments <i class="fas fa-chevron-down"></i></a>
            <ul class="dropdown-content">
                <li><a href="judgments.php">Judgments</a></li>
                <li><a href="special_determination.php">Special Determinations</a></li>
            </ul>
        </li>
            <li class="dropdown">
    <a href="#">Resources for Citizens <i class="fas fa-chevron-down"></i></a>
    <ul class="dropdown-content">
        
        <li class="dropdown-submenu">
            <a href="#">Information to Litigants <i class="fas fa-chevron-right" style="float: right; font-size: 0.7rem; margin-top: 5px;"></i></a>
            <ul class="submenu-content">
                <li><a href="info_citizens.php">Information to Litigants</a></li>
                <li><a href="#">Status of concluded cases</a></li>
            </ul>
        </li>

        <li class="dropdown-submenu">
            <a href="#">Certified Copies <i class="fas fa-chevron-right" style="float: right; font-size: 0.7rem; margin-top: 5px;"></i></a>
            <ul class="submenu-content">
                <li><a href="#">Online application</a></li>
                <li><a href="#">Track Your Request</a></li>
            </ul>
        </li>

        <li><a href="#">Judiciary Statistics</a></li>
    </ul>
</li>
            <li><a href="#">Professionals</a></li>
            <li><a href="news_notices.php">News & Notices</a></li>
        </ul>
    </nav>
    
    <div class="header-icons">
        <i class="fas fa-search search-btn"></i>
        <i class="fas fa-bars menu-btn" onclick="toggleSidebar()"></i>
    </div>

</header>

<div class="sidebar" id="mySidebar">
    
    <div class="close-btn" onclick="toggleSidebar()">&times;</div>

    <div class="mobile-nav-links" style="display:none;">
        <h3>Menu</h3>
        <ul>
            <li><a href="index.php">Home</a></li>
            <li><a href="judges.php">Judges</a></li>
            <li><a href="daily_list.php">Court Diary</a></li>
            <li><a href="#">Judgments</a></li>
            <li><a href="#">Contact</a></li>
        </ul>
    </div>

    <h3>Recent Posts</h3>
    <div class="sidebar-post">
        <a href="#">Food industry leaders often change their promoters.</a>
    </div>
    <div class="sidebar-post">
        <a href="#">Court Holiday Notice – Poson Poya</a>
    </div>

    <h3>Contact Us</h3>
    <div class="contact-item">
        <i class="fas fa-phone-alt"></i>
        <p>+94 011 243 7507 (24/7 Support Line)</p>
    </div>
    <div class="contact-item">
        <i class="fas fa-envelope"></i>
        <p>scdreg@sltnet.lk</p>
    </div>
    <div class="contact-item">
        <i class="fas fa-home"></i>
        <p>WVM6+RR9, Hulftsdorp St,<br>Colombo 01200</p>
    </div>

    <h3>Follow Us</h3>
    <div class="social-links">
        <a href="#" class="social-btn fb"><i class="fab fa-facebook-f"></i></a>
        <a href="#" class="social-btn tw"><i class="fab fa-twitter"></i></a>
        <a href="#" class="social-btn ln"><i class="fab fa-linkedin-in"></i></a>
        <a href="#" class="social-btn in"><i class="fab fa-instagram"></i></a>
    </div>

</div>
<script>
    // Toggle Sidebar Function
    function toggleSidebar() {
        var sidebar = document.getElementById("mySidebar");
        sidebar.classList.toggle("active");
    }

    // Sticky Header
    window.addEventListener("scroll", function(){
        var header = document.querySelector("header");
        header.classList.toggle("sticky", window.scrollY > 0);
    });
</script>