<?php 
    include 'db_connect.php'; 
    include 'header.php'; 
?>

<section class="page-hero" style="height: 40vh; background: linear-gradient(rgba(42, 10, 46, 0.185), rgba(42, 10, 46, 0.185)), url('images/judge-s-gavel-table-court-room-closeup-concept-justice-law-generative-ai.jpg') no-repeat center center/cover;">
    <div class="container">
        <h1>Full Court Diary</h1>
        <p>Search the comprehensive archive of all scheduled court proceedings.</p>
    </div>
</section>

<section class="content-section reveal" style="padding: 80px 8%; background-color: #fff; min-height: 50vh;">
    
    <div style="max-width: 800px; margin: 0 auto;">
        
        <div class="search-box" style="margin-bottom: 40px;">
            <label style="font-size: 1.1rem; color:var(--primary-color); font-weight: 600; margin-bottom: 15px; display: block;">Select Trial Date:</label>
            
            <form action="" method="GET" style="display:flex; gap:15px; flex-wrap: wrap;">
                <input type="date" name="search_date" class="form-control" style="flex: 1; padding: 12px; font-size: 1rem; border: 1px solid #ccc; border-radius: 4px;">
                <button type="submit" class="btn-gold" style="border:none; cursor:pointer; padding: 12px 40px; font-size: 1rem; border-radius: 4px;">Search</button>
            </form>
        </div>

        <div style="border-bottom: 1px solid #eee; margin-bottom: 40px;"></div>

        <div class="search-results">
            <?php
                // Simple PHP check to simulate search results
                if(isset($_GET['search_date'])) {
                    $search_date = $_GET['search_date'];
                    echo '<div style="padding: 20px; border-left: 4px solid var(--gold-accent); background: #fafafa; color: #555;">';
                    echo '<h4>Search Results for: ' . htmlspecialchars($search_date) . '</h4>';
                    echo '<p style="margin-top: 10px;">No records found for this date. Please try selecting a different date.</p>';
                    echo '</div>';
                } else {
                    // Default State
                    echo '<p style="color: #777; font-style: italic;">Please select a date above to view the court diary.</p>';
                }
            ?>
        </div>

    </div>

</section>

<script>
    window.addEventListener('scroll', function() {
        var reveals = document.querySelectorAll('.reveal');
        for(var i = 0; i < reveals.length; i++){
            var windowheight = window.innerHeight;
            var revealtop = reveals[i].getBoundingClientRect().top;
            var revealpoint = 150;
            if(revealtop < windowheight - revealpoint){
                reveals[i].classList.add('active');
            }
        }
    });
</script>

<?php include 'footer.php'; ?>