<?php include 'header.php'; ?>

<div class="page-header">
    <div class="container">
        <h1>About the High Court</h1>
        <p>Home <i class="fas fa-chevron-right"></i> About Us <i class="fas fa-chevron-right"></i> History & Jurisdiction</p>
    </div>
</div>

<div class="container page-content">
    
    <aside class="sidebar-nav">
        <h3>About Us</h3>
        <ul>
            <li><a href="#" class="active"><i class="fas fa-history"></i> History & Overview</a></li>
            <li><a href="#"><i class="fas fa-gavel"></i> Jurisdiction</a></li>
            <li><a href="#"><i class="fas fa-user-tie"></i> Judges of the High Court</a></li>
            <li><a href="#"><i class="fas fa-landmark"></i> Commercial High Court</a></li>
            <li><a href="#"><i class="fas fa-scroll"></i> Past Judges</a></li>
            <li><a href="#"><i class="fas fa-balance-scale"></i> Court Rules</a></li>
        </ul>

        <div class="sidebar-box">
            <h4><i class="fas fa-clock"></i> Opening Hours</h4>
            <p><strong>Registry:</strong> 8:00 AM - 3:30 PM</p>
            <p><strong>Court Sittings:</strong> 9:30 AM - 4:00 PM</p>
            <p style="font-size: 12px; margin-top: 10px;">*Closed on weekends & Poya days</p>
        </div>
    </aside>

    <main class="main-text">
        <h2 class="section-title">The High Court of the Republic of Sri Lanka</h2>
        
        <img src="https://upload.wikimedia.org/wikipedia/commons/4/4e/Supreme_Court_Complex_Sri_Lanka.jpg" alt="High Court Building" class="featured-image">

        <p class="lead">
            The High Court is the highest court of first instance in Sri Lanka exercising criminal jurisdiction. It is empowered to inflict any sentence authorized by law, including the death penalty and life imprisonment.
        </p>

        <h3>Historical Background</h3>
        <p>
            The judicial system of Sri Lanka has a rich history evolving from the Roman-Dutch law and English Common Law. The High Court was established under the Constitution of the Democratic Socialist Republic of Sri Lanka to serve as a pivotal institution in the administration of justice.
        </p>
        <p>
            Unlike the Magistrate Courts or District Courts, the High Court holds trial by jury for serious offenses, a tradition that underscores the democratic participation in the judicial process.
        </p>

        <h3>Jurisdiction & Powers</h3>
        <p>The High Court exercises three primary types of jurisdiction:</p>
        <ul class="content-list">
            <li><strong>Criminal Jurisdiction:</strong> Trials for grave offenses such as murder, rape, and treason are heard here, often indicted by the Attorney General.</li>
            <li><strong>Commercial Jurisdiction:</strong> The High Court of the Western Province (Civil) acts as the Commercial High Court, handling high-value commercial and intellectual property disputes.</li>
            <li><strong>Appellate Jurisdiction:</strong> The Civil Appellate High Courts hear appeals from District Courts and Magistrate Courts within their respective provinces.</li>
        </ul>

        <div class="quote-box">
            "Justice delayed is justice denied. The High Court is committed to the efficient and fair disposal of cases to uphold the Rule of Law."
        </div>

    </main>
</div>

<?php include 'footer.php'; ?>