<?php
$page_title = "Contact Us - Dissanayaka Engineers";
$page_description = "Contact Dissanayaka Engineers for all your steel fabrication needs";
include 'includes/header.php';
include 'includes/navigation.php';
?>

    <article class="entry">
      <div class="entry-content">
        <!-- contact form-->
        <div class="container-fluid px-0 ">
          <div class="pt-lg-9" style="background-image: url('assets/images/contact/contact.jpg'); background-size: cover; background-position: center;">

            <div class="container">
              <div class="row gx-lg-5">
                <div class="col-lg-6 mt-lg-0 mt-md-5 mt-5">
                  <h1 class="mb-4">We're here to help</h1>
                  <p class="lead-1 text-dim-gray">Fill out the form or call +94 11 518 386. Visit us at our main workshop in Ratnapura.</p>
                  <!-- form-->
                  <div class="pr-lg-5 pt-lg-5 pb-lg-7 pt-md-5 pb-md-0 pt-5 pb-5">
                    <form id="contact-us-form" method="post" action="assets/php/contact.php">
                      <div class="mb-4 pb-2">
                        <input class="form-control input-border border-bottom border-1 border-black-pearl" id="form_firstname" type="text" name="fname" placeholder="Name" required>
                      </div>
                      <div class="mb-4 pb-2">
                        <input class="form-control input-border border-bottom border-1 border-black-pearl" id="form_email" type="email" name="lname" placeholder="Email" required>
                      </div>
                      <div class="mb-4 pb-2">
                        <input class="form-control input-border border-bottom border-1 border-black-pearl" id="subject" type="text" name="subject" placeholder="Subject">
                      </div>
                      <div class="mb-4 pb-2">
                        <textarea class="form-control input-border border-bottom border-1 border-black-pearl" id="form_message" name="message" placeholder="Message" rows="5" required></textarea>
                      </div>
                      <div class="mb-4"> <button type="submit" class="btn btn-black-pearl">Submit</button></div>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        
        <!-- Map & Contact Info Section -->
<div class="container my-lg-9 my-md-7 my-5">
  <div class="row gx-lg-5 align-items-stretch classy-contact">

    <!-- Left: Google Map -->
    <div class="col-lg-6 mb-4 mb-lg-0">
      <div class="map-responsive classy-map">
        <iframe 
          id="gmap_canvas1" 
          width="100%" 
          height="100%" 
          src="https://maps.google.com/maps?q=Ratnapura,%20Sri%20Lanka&amp;t=&amp;z=13&amp;ie=UTF8&amp;iwloc=&amp;output=embed" 
          frameborder="0" 
          allowfullscreen>
        </iframe>
      </div>
    </div>

    <!-- Right: Contact Info -->
    <div class="col-lg-6 d-flex align-items-center">
      <div class="contact-details-box shadow-sm p-5 w-100 bg-white rounded-4">
        <h3 class="mb-4 text-black-pearl">Contact Us</h3>
        <p class="lead text-muted mb-3"><strong>Main Workshop:</strong> No 452, Weralupa, Colombo Road, Ratnapura</p>
        <p class="lead text-muted mb-3"><strong>Showroom:</strong> Balangoda & Embilipitiya</p>
        <p class="lead text-muted mb-3"><strong>Email:</strong> <a href="mailto:dissanayakaeng@gmail.com" class="text-black-pearl text-decoration-none">dissanayakaeng@gmail.com</a></p>
        <p class="lead text-muted"><strong>Phone:</strong> <a href="tel:+94115183860" class="text-black-pearl text-decoration-none">+94 11 518 386</a></p>
      </div>
    </div>

  </div>
</div>


      </div>
    </article>
    <style>

      .classy-contact {
  font-family: 'Segoe UI', 'Helvetica Neue', sans-serif;
}

.classy-map iframe {
  border-radius: 10px;
  min-height: 400px;
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
}

.contact-details-box {
  background-color: #ffffff;
  border-left: 4px solid #212529; /* accent color */
  transition: transform 0.3s ease;
}

.contact-details-box:hover {
  transform: translateY(-5px);
  box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
}

.text-black-pearl {
  color: #212529; /* deep charcoal */
}

a.text-black-pearl:hover {
  text-decoration: underline;
}
    </style>

<?php
include 'includes/footer.php';
?>