<?php
$page_title = "Home - Dissanayaka Engineers";
$page_description = "A Template for Architectural Interior Design company website.";
include 'includes/header.php';
include 'includes/navigation.php';
?>

    <article class="entry">
      <!-- Bootstrap Carousel Slider with Background Images -->
<div id="steelCarousel" class="carousel slide carousel-fade" data-bs-ride="carousel" data-bs-interval="5000">
  <div class="carousel-inner">

    <!-- Slide 1 -->
    <div class="carousel-item active">
      <div class="container-fluid px-0" style="background-image: url('assets/images/home/h15.jpg'); background-size: cover; background-position: center; height: 80vh;">
        <div class="row gx-lg-5 px-5 h-100 align-items-center">
          <div class="col-lg-6 my-lg-3 mt-md-5 mt-5">
            <h5 class="text-primary-blue" style="font-weight: 700; font-size: 1.8rem; text-shadow: 2px 2px 4px rgba(0,0,0,0.7); color: #2E5CB8 !important;">We are</h5>
            <div class="pr-lg-6 pr-md-8 pr-4">
              <h1 class="text-white mb-4">Inventing The Best Steels For A Better World</h1>
              <p class="lead text-silver mb-4">At the heart of our mission is a commitment to innovation, strength, and sustainability. We are not just producing steel—</p>
            </div>
            <div class="row gx-lg-0 pt-3 mb-lg-3">
              <div class="col-lg-4 col-md-4 col-12">
  <a class="btn btn-white" href="page-about-us.php">Read more</a>
</div>

              <div class="col-lg-4 col-md-4 col-12 mt-lg-0 mt-md-0 mt-4">
                <div class="ml-n28"><a class="btn btn-primary-blue" href="page-contact.php">Contact us</a></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Slide 2 -->
    <div class="carousel-item">
      <div class="container-fluid px-0" style="background-image: url('assets/images/home/h18.jpg'); background-size: cover; background-position: center; height: 80vh;">
        <div class="row gx-lg-5 px-5 h-100 align-items-center">
          <div class="col-lg-6 my-lg-3 mt-md-5 mt-5">
            <h5 class="text-primary-blue" style="font-weight: 700; font-size: 1.8rem; text-shadow: 2px 2px 4px rgba(0,0,0,0.7); color: #2E5CB8 !important;">We are</h5>
            <div class="pr-lg-6 pr-md-8 pr-4">
              <h1 class="text-white mb-4">Inventing The Best Steels For A Better World</h1>
              <p class="lead text-silver mb-4">At the heart of our mission is a commitment to innovation, strength, and sustainability. We are not just producing steel—</p>
            </div>
            <div class="row gx-lg-0 pt-3 mb-lg-3">
              <div class="col-lg-4 col-md-4 col-12">
  <a class="btn btn-white" href="page-about-us.php">Read more</a>
</div>
              <div class="col-lg-4 col-md-4 col-12 mt-lg-0 mt-md-0 mt-4">
                <div class="ml-n28"><a class="btn btn-primary-blue" href="page-contact.php">Contact us</a></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>
</div>

<style>
  .btn-white {
    background-color: #ffffff;
    color: #000000;
    border: 1px solid #ffffff;
  }

  .btn-white:hover {
    background-color: #f0f0f0;
    color: #000;
  }
</style>



        <!-- tab section-->
        <div class="bg-white-smoke">
          <div class="pt-lg-8 pb-lg-5 pt-md-8 pb-md-5 pt-7 pb-5">
            <div class="container">
              <div class="row">
                <div class="col-lg-8 offset-lg-2">
                  <div class="text-center mx-lg-0 mx-md-0 mx-3">
                    <h2 class="mb-4">Advancing products , processes and solutions</h2>
                    <p>Our company was founded in 1995 as Dissanayaka Engineers. Starting as a sole proprietor business, we have evolved into a successful partnership led by Mr. S.D. Anil Indratilaka and his son Mr. S.D. Eashan Dissanayaka. We are proud to have worked on major stainless steel projects island-wide and serve as a wholesale center for stainless steel tubes, sheets, and accessories throughout the Sabaragamuwa province.</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="container pb-lg-7">
            <div class="row gx-lg-5">
              <div class="col-lg-6"><img class="height-px-420 object-fit-cover w-100" src="assets/images/home/IMG_-249.jpg" alt="home6"></div>
              <div class="col-lg-6 mt-lg-0 mt-md-5 mt-5"> 
                <nav class="pr-lg-5">
                  <div class="nav nav-tabs" id="nav-tab" role="tablist"><a class="h6 nav-link active mr-md-6 mr-3" id="nav-Stratigy-tab" data-toggle="tab" href="#nav-Stratigy" role="tab" aria-controls="nav-Stratigy" aria-selected="true">Stratigy</a><a class="h6 nav-link mr-md-6 mr-3" id="nav-Organization-tab" data-toggle="tab" href="#nav-Organization" role="tab" aria-controls="nav-Organization" aria-selected="false">Organization</a><a class="h6 nav-link mr-md-6 mr-3" id="nav-Development-tab" data-toggle="tab" href="#nav-Development" role="tab" aria-controls="nav-Development" aria-selected="false">Development</a><a class="h6 nav-link" id="nav-Delivery-tab" data-toggle="tab" href="#nav-Delivery" role="tab" aria-controls="nav-Delivery" aria-selected="false">Delivery</a></div>
                  <div class="tab-content mt-3" id="nav-tabContent">
                    <div class="tab-pane fade show active" id="nav-Stratigy" role="tabpanel" aria-labelledby="nav-Stratigy-tab">
                      <div class="pt-lg-4 pt-3">
                        <p class="lead text-black-pearl font-medium">Founded in 1995, Dissanayaka Engineers began as a sole proprietor business and has grown into a successful partnership operation.</p>
                        <p>Our company has established itself as a leading player in Sri Lanka's stainless steel industry. We have successfully completed numerous major projects across the island, demonstrating our expertise and reliability in handling complex stainless steel fabrication requirements. Our strategic approach focuses on quality, innovation, and customer satisfaction.</p>
                      </div>
                    </div>
                    <div class="tab-pane fade" id="nav-Organization" role="tabpanel" aria-labelledby="nav-Organization-tab">
                      <div class="pt-lg-4 pt-3">
                        <p class="lead text-black-pearl font-medium">Dissanayaka Engineers is now a partnership business led by experienced professionals who understand the steel industry inside and out.</p>
                        <p>The company is owned and operated by Mr. S.D. Anil Indratilaka and his son Mr. S.D. Eashan Dissanayaka, combining decades of experience with fresh perspectives. This father-son partnership ensures continuity, innovation, and a deep understanding of both traditional craftsmanship and modern steel fabrication techniques. Our organizational structure promotes efficient decision-making and maintains the highest standards of quality control.</p>
                      </div>
                    </div>
                    <div class="tab-pane fade" id="nav-Development" role="tabpanel" aria-labelledby="nav-Development-tab">
                      <div class="pt-lg-4 pt-3">
                        <p class="lead text-black-pearl font-medium">Beyond project work, we have developed into a comprehensive wholesale center for stainless steel materials and accessories.</p>
                        <p>Our company operates as a wholesale distribution center for stainless steel tubes, sheets, and accessories, serving customers throughout the Sabaragamuwa province. We stock a wide range of high-quality materials and distribute raw materials to manufacturers, contractors, and smaller fabricators. This wholesale operation has positioned us as a key supplier in the regional market, supporting the growth of the stainless steel industry across Sri Lanka.</p>
                      </div>
                    </div>
                    <div class="tab-pane fade" id="nav-Delivery" role="tabpanel" aria-labelledby="nav-Delivery-tab">
                      <div class="pt-lg-4 pt-3">
                        <p class="lead text-black-pearl font-medium">There is significant and growing demand for stainless steel products in Sri Lanka, making this industry increasingly important to the country's development.</p>
                        <p>The stainless steel industry in Sri Lanka has gained considerable attention due to increasing construction activities, infrastructure development, and industrial growth. With substantial imports of stainless steel materials, companies like ours play a crucial role in processing, fabricating, and distributing these materials efficiently. We are well-positioned to meet this growing demand through our established supply chains, experienced workforce, and strategic location in the Sabaragamuwa province.</p>
                      </div>
                    </div>
                  </div>
                </nav>
              </div>
            </div>
          </div>
        </div>
        
        <!-- second bg section-->
        <div class="container-fluid px-0 home-bg-1 bg-black-pearl" style="background-image: url('assets/images/home/h19.jpg'); background-size: cover; background-position: center; background-repeat: no-repeat;">

          <div class="py-lg-9 py-md-8 pt-0 pb-6">
            <div class="container">
              <div class="row gx-lg-5">
                <div class="col-lg-6 home-bg-11 order-lg-1">
                </div>
                <div class="col-lg-6 home-bg-11 order-lg-1">
                  <br><br><br><h5 class="text-primary-blue" style="font-weight: 700; font-size: 1.8rem; text-shadow: 2px 2px 4px rgba(0,0,0,0.8); color: #2E5CB8 !important;">Our goals</h5>
                  <div class="pr-lg-6 pr-md-7 pr-2">
                    <h2 class="text-white mb-4">Our not-so-secret plan: Create a world without waste</h2>
                    <p class="text-silver mb-4">At the heart of everything we do is a simple but powerful mission: to create a world without waste. We're committed to designing sustainable solutions, minimizing environmental impact, and rethinking how resources are used—from production to reuse. It's not just a vision; it's our plan in action.</p>
                    <div class="pt-3"><a class="btn btn-primary-blue mb-lg-3" href="page-about-us.php">Learn more</a></div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        
        <!-- Product Filter Buttons -->
<br><div class="container text-center mb-5">
  <h2 class="mb-4">Products</h2>
  <div class="btn-group" role="group" aria-label="Product filters">
    <button type="button" class="btn btn-outline-dark active" data-filter="all">All</button>
    <button type="button" class="btn btn-outline-dark" data-filter="beams">Beams</button>
    <button type="button" class="btn btn-outline-dark" data-filter="fabrications">Fabrications</button>
    <button type="button" class="btn btn-outline-dark" data-filter="components">Components</button>
  </div>
</div>

<!-- Product Grid -->
<div class="container mb-5">
  <div class="row gx-lg-5">

    <!-- Beams -->
    <div class="col-lg-4 col-md-6 mb-4 product-item" data-category="beams">
      <a href="page-portfolio-list.php"><img src="assets/images/home/WhatsApp_Image_2022-12-20_at_3_20_30_PM.jpeg" class="img-fluid" alt="Beams 1"></a>
      <div class="bg-white-smoke px-4 py-4">
        <h3>Steel Beam A</h3>
        <div class="text-end pt-2"><a href="page-portfolio-list.php"><i class="h5 fas fa-arrow-right"></i></a></div>
      </div>
    </div>

    <!-- Fabrications -->
    <div class="col-lg-4 col-md-6 mb-4 product-item" data-category="fabrications">
      <a href="page-portfolio-list.php"><img src="assets/images/home/Mild-steel-products-800x600.webp" class="img-fluid" alt="Fabrication 1"></a>
      <div class="bg-white-smoke px-4 py-4">
        <h3>Custom Fabrication B</h3>
        <div class="text-end pt-2"><a href="page-portfolio-list.php"><i class="h5 fas fa-arrow-right"></i></a></div>
      </div>
    </div>

    <!-- Components -->
    <div class="col-lg-4 col-md-6 mb-4 product-item" data-category="components">
      <a href="page-portfolio-list.php"><img src="assets/images/home/structural-steel-scaled.jpeg" class="img-fluid" alt="Component 1"></a>
      <div class="bg-white-smoke px-4 py-4">
        <h3>Industrial Component C</h3>
        <div class="text-end pt-2"><a href="page-portfolio-list.php"><i class="h5 fas fa-arrow-right"></i></a></div>
      </div>
    </div>

    <!-- Another Beams -->
    <div class="col-lg-4 col-md-6 mb-4 product-item" data-category="beams">
      <a href="page-portfolio-list.php"><img src="assets/images/home/structural-steel-scaled.jpeg" class="img-fluid" alt="Beams 2"></a>
      <div class="bg-white-smoke px-4 py-4">
        <h3>Steel Beam D</h3>
        <div class="text-end pt-2"><a href="page-portfolio-list.php"><i class="h5 fas fa-arrow-right"></i></a></div>
      </div>
    </div>

    <!-- Another Component -->
    <div class="col-lg-4 col-md-6 mb-4 product-item" data-category="components">
      <a href="page-portfolio-list.php"><img src="assets/images/home/Mild-steel-products-800x600.webp" class="img-fluid" alt="Component 2"></a>
      <div class="bg-white-smoke px-4 py-4">
        <h3>Gear Housing E</h3>
        <div class="text-end pt-2"><a href="page-portfolio-list.php"><i class="h5 fas fa-arrow-right"></i></a></div>
      </div>
    </div>

    <!-- Another Fabrication -->
    <div class="col-lg-4 col-md-6 mb-4 product-item" data-category="fabrications">
      <a href="page-portfolio-list.php"><img src="assets/images/home/WhatsApp_Image_2022-12-20_at_3_20_30_PM.jpeg" class="img-fluid" alt="Fabrication 2"></a>
      <div class="bg-white-smoke px-4 py-4">
        <h3>Custom Frame F</h3>
        <div class="text-end pt-2"><a href="page-portfolio-list.php"><i class="h5 fas fa-arrow-right"></i></a></div>
      </div>
    </div>

  </div>
</div>

      </div>
    </article>
    <style>
  .product-item h3,
  .product-item p,
  .product-item a {
    color: #000 !important;
  }
</style>

<?php
$additional_js = '
<script>
  const filterButtons = document.querySelectorAll(\'[data-filter]\');
  const productItems = document.querySelectorAll(\'.product-item\');

  filterButtons.forEach(btn => {
    btn.addEventListener(\'click\', () => {
      filterButtons.forEach(b => b.classList.remove(\'active\'));
      btn.classList.add(\'active\');

      const filter = btn.getAttribute(\'data-filter\');

      productItems.forEach(item => {
        const category = item.getAttribute(\'data-category\');
        if (filter === \'all\' || category === filter) {
          item.style.display = \'\';
        } else {
          item.style.display = \'none\';
        }
      });
    });
  });
</script>';
include 'includes/footer.php';
?>